//: ## ✅ Control Flow
//:
//: Code is executed line by line from top to bottom.
//:
//: We can write conditions to break code away from its current path and down through another funnel of code instructions. The construction of this flow of code execution is called "Control Flow".
//:
//: Swift has several commands we can use, such as If Statements.
//:
//: -------------------
//:
//: [◀  Previous Page](@previous)  |  [Next Page  ▶](@next)
//:
//: -------------------
//:
//: ## If Statements
//:
//: -------------------
//:


// if statements
if (10 > 1) == true {
    print("ten is greater")
}

// no brackets!
if 10 > 1 {
    print("ten is greater")
}

if (true == true) {
    print("The condition is true. This code will execute.")
}

// no == true
if (true) {
    print("The condition is true. This code will execute.")
}

// a student had an exam
var studentPassed = false
let exam1Score: Int = 50
if exam1Score > 50 {
    studentPassed = true
}

if exam1Score > 50 {
    print("Passed the exam!")
} else {
    print("Failed the exam!")
}

if exam1Score > 90 {
    print("A+")
} else if exam1Score > 80 {
    print("A")
} else if exam1Score > 70 {
    print("A-")
} else if exam1Score > 60 {
    print("B")
} else if exam1Score > 50 {
    print("C")
} else if exam1Score > 40 {
    print("D")
} else if exam1Score > 30 {
    print("E")
} else if exam1Score > 20 {
    print("F")
} else if exam1Score > 10 {
    print("F")
} else {
    print("F")
}


//:
//: -------------------
//:
//: ## For-in Loops
//:
//: -------------------
//:


// for-in loops
for i in 0...100 {
    print(i)
}

let examScores = [50, 77, 90, 45]
var totalScore = 0
for score in examScores {
    totalScore += score
}
let scoreRequiredToGraduate = 200
if totalScore > scoreRequiredToGraduate {
    print("Graduated! 🧑🏽‍🎓 👩🏽‍🎓 👩🏼‍🎓 🎉")
}

let interestingNumbers = [
    "Prime":
        [2, 3, 5, 7, 11, 13],
    "Fibonacci":
        [1, 1, 2, 3, 5, 8],
    "Square":
        [1, 4, 9, 16, 25],
]
var largestNumber = 0
for (_, numbers) in interestingNumbers {
    for number in numbers {
        if number > largestNumber {
            largestNumber = number
        }
    }
}
print(largestNumber)


//:
//: -------------------
//:
//: ## While Loops
//:
//: -------------------
//:


// while loops
var n = 2
while n < 100 {
    n *= 2
}
print(n)

var m = 2
repeat {
    m *= 2
} while m < 100
print(m)


//:
//: -------------------
//:
//: ## Switch Statements
//:
//: -------------------
//:


// switch statements
let age = 40
switch age {
case 0...50:
    print("0 to 50 years old")
case 51...60:
    print("51 to 50 years old")
case 61...70:
    print("61 to 70 years old")
case 71...80:
    print("71 to 80 years old")
case 81...90:
    print("81 to 90 years old")
case 91...100:
    print("91 to 100 years old")
default:
    print("Age is \(age)")
}

// less scenarios
enum Scenarios {
    case scenario1
    case scenario2
}

let scenario = Scenarios.scenario1
switch scenario {
case .scenario1:
    print("scenario1")
case .scenario2:
    print("scenario2")
}


//:
//: -------------------
//:
//: ## Where Clause
//:
//: -------------------
//:


// where clauses
let vegetable = "red pepper"
switch vegetable {
    case let x where x.hasSuffix("pepper"):
        print("Is it a spicy \(x)?")
    case "celery":
        print("Add some raisins and make ants on a log.")
    case "cucumber", "watercress":
        print("That would make a good tea sandwich.")
    default:
        print("Everything tastes good in soup.")
}


//:
//:
//: -------------------
//:
//: [◀  Previous Page](@previous)  |  [Next Page  ▶](@next)
//:
//: -------------------
//:
//: ## ![3 Days Of Swift Logo](3DaysIcon146.png) 3 Days Of Swift
//:
//: © Copyright. All rights reserved.
//:
//: 🧕🏻🙋🏽‍♂️👨🏿‍💼👩🏼‍💼👩🏻‍💻💁🏼‍♀️👨🏼‍💼🙋🏻‍♂️🙋🏻‍♀️👩🏼‍💻🙋🏿💁🏽‍♂️🙋🏽‍♀️🙋🏿‍♀️🧕🏾🙋🏼‍♂️
//:
//: Welcome to our community of [3DaysOfSwift.com](https://www.3DaysOfSwift.com) developers!
